/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.common.attribute.Attribs;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.container.RepairStationContainer;
import dev.toma.gunsrpg.common.container.SimpleContainerChangeListener;
import dev.toma.gunsrpg.common.item.guns.GunItem;
import dev.toma.gunsrpg.common.tileentity.RepairStationTileEntity;
import dev.toma.gunsrpg.network.NetworkManager;
import dev.toma.gunsrpg.network.packet.C2S_RequestRepairPacket;
import dev.toma.gunsrpg.util.ModUtils;
import dev.toma.gunsrpg.util.RenderUtils;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lib.toma.animations.QuickSort;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class RepairStationScreen
extends ContainerScreen<RepairStationContainer> {
    private static final ITextComponent TEXT_REPAIR = new TranslationTextComponent("screen.button.repair");
    private static final ResourceLocation TEXTURE = GunsRPG.makeResource("textures/screen/repair_station.png");
    private final Map<DamageType, DamageHolder> damageDataMap = Arrays.stream(DamageType.values()).map(DamageHolder::new).collect(Collectors.toMap(DamageHolder::getType, Function.identity()));
    private final IContainerListener listener;
    private Button repairButton;
    private IPlayerData data;

    public RepairStationScreen(RepairStationContainer container, PlayerInventory inventory, ITextComponent title) {
        super((Container)container, inventory, title);
        this.field_147000_g = 164;
        this.listener = new SimpleContainerChangeListener(this::slotChanged);
        ((RepairStationContainer)this.field_147002_h).func_75132_a(this.listener);
    }

    public void func_231164_f_() {
        ((RepairStationContainer)this.field_147002_h).func_82847_b(this.listener);
        super.func_231164_f_();
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        ITextComponent inventoryText = this.field_213127_e.func_145748_c_();
        int labelWidth = this.field_230712_o_.func_238414_a_((ITextProperties)inventoryText);
        this.field_238744_r_ = this.field_146999_f - 8 - labelWidth;
        this.repairButton = (Button)this.func_230480_a_((Widget)new Button(this.field_147003_i + 116, this.field_147009_r + 45, 52, 20, TEXT_REPAIR, this::repair));
        this.slotChanged(0, ItemStack.field_190927_a);
        this.data = PlayerData.getUnsafe((PlayerEntity)this.field_230706_i_.field_71439_g);
    }

    protected void func_230450_a_(MatrixStack stack, float partialTicks, int mouseX, int mouseY) {
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        this.func_238474_b_(stack, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        ItemStack itemStack = ((RepairStationTileEntity)((Object)((RepairStationContainer)this.field_147002_h).getTileEntity())).getItemHandler().getStackInSlot(0);
        if (!itemStack.func_190926_b()) {
            this.renderDamageModel(stack, itemStack, mouseX, mouseY);
        }
    }

    protected void func_230451_b_(MatrixStack stack, int mouseX, int mouseY) {
        this.field_230712_o_.func_243248_b(stack, this.field_230704_d_, (float)this.field_238742_p_, (float)this.field_238743_q_, 0x404040);
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(stack);
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(stack, mouseX, mouseY);
    }

    private void slotChanged(int slot, ItemStack stack) {
        if (this.repairButton == null) {
            return;
        }
        RepairStationTileEntity tile = (RepairStationTileEntity)((Object)((RepairStationContainer)this.field_147002_h).getTileEntity());
        this.repairButton.field_230693_o_ = tile.canRepair();
    }

    private void repair(Button button) {
        if (((RepairStationTileEntity)((Object)((RepairStationContainer)this.field_147002_h).getTileEntity())).canRepair()) {
            NetworkManager.sendServerPacket(new C2S_RequestRepairPacket(((RepairStationTileEntity)((Object)((RepairStationContainer)this.field_147002_h).getTileEntity())).func_174877_v()));
        }
    }

    private void renderDamageModel(MatrixStack matrixStack, ItemStack stack, int mouseX, int mouseY) {
        float currentLimit = ((GunItem)stack.func_77973_b()).getDurabilityLimit(stack);
        float currentDurability = 1.0f - (float)stack.func_77952_i() / (float)stack.func_77958_k();
        DamageHolder[] holders = this.getSortedHolders(currentLimit, currentDurability);
        Matrix4f pose = matrixStack.func_227866_c_().func_227870_a_();
        for (DamageHolder holder : holders) {
            this.renderDamageHolder(pose, holder);
        }
        this.renderHovered(matrixStack, holders, mouseX, mouseY);
    }

    private void renderHovered(MatrixStack stack, DamageHolder[] holders, int mouseX, int mouseY) {
        ModUtils.inverse(holders);
        DamageHolder[] damageHolderArray = holders;
        int n = damageHolderArray.length;
        for (int i = 0; i < n; ++i) {
            int bottom;
            int left = this.field_147003_i + 7;
            int top = this.field_147009_r + 68;
            DamageHolder holder = damageHolderArray[i];
            int xDiff = (int)(161.0f * holder.getValue());
            int right = left + xDiff;
            boolean hovered = ModUtils.isWithinPoints(mouseX, mouseY, left, top, right, bottom = this.field_147009_r + 77);
            if (!hovered) continue;
            StringTextComponent desc = new StringTextComponent(((DamageHolder)holder).type.description);
            this.func_238652_a_(stack, (ITextComponent)desc, mouseX, mouseY);
            break;
        }
    }

    private void renderDamageHolder(Matrix4f pose, DamageHolder holder) {
        DamageType type = holder.getType();
        int primaryRgb = type.colorPrimary;
        int secondaryRgb = type.colorSecondary;
        int xDiff = (int)(161.0f * holder.getValue());
        RenderUtils.drawGradient(pose, this.field_147003_i + 7, this.field_147009_r + 68, this.field_147003_i + 7 + xDiff, this.field_147009_r + 77, primaryRgb, secondaryRgb);
    }

    private DamageHolder[] getSortedHolders(float limit, float current) {
        float after = limit * this.data.getAttributes().getAttribute(Attribs.REPAIR_PENALTY).floatValue();
        this.damageDataMap.get((Object)DamageType.TOTAL_LIMIT).setValue(1.0f);
        this.damageDataMap.get((Object)DamageType.CURRENT_LIMIT).setValue(limit);
        this.damageDataMap.get((Object)DamageType.CURRENT).setValue(current);
        this.damageDataMap.get((Object)DamageType.AFTER_REPAIR).setValue(after);
        DamageHolder[] holders = this.damageDataMap.values().toArray(new DamageHolder[0]);
        QuickSort.sort(holders, Comparator.comparingDouble(DamageHolder::getValue).reversed().thenComparing(Comparator.comparing(DamageHolder::getType).reversed()));
        return holders;
    }

    private static class DamageHolder {
        private final DamageType type;
        private float value;

        public DamageHolder(DamageType type) {
            this.type = type;
        }

        public DamageType getType() {
            return this.type;
        }

        public void setValue(float value) {
            this.value = value;
        }

        public float getValue() {
            return this.value;
        }
    }

    private static enum DamageType {
        CURRENT(38143, "Current durability"),
        CURRENT_LIMIT(0x8B8B8B, "Current max durability"),
        TOTAL_LIMIT(0xAA0000, 0, "Total weapon durability"),
        AFTER_REPAIR(16753408, "Durability after repair");

        final int colorPrimary;
        final int colorSecondary;
        final String description;

        private DamageType(int colorPrimary, int colorSecondary, String description) {
            this.colorPrimary = colorPrimary | 0xFF000000;
            this.colorSecondary = colorSecondary | 0xFF000000;
            this.description = description;
        }

        private DamageType(int colorPrimary, String description) {
            this.colorPrimary = 0xFF000000 | colorPrimary;
            this.colorSecondary = 0xFF000000 | RenderUtils.darken(this.colorPrimary, 0.5f);
            this.description = description;
        }
    }
}

